<?php
function app_cfg(): array {
  static $cfg;
  if (!$cfg) $cfg = require __DIR__ . '/../config/app.php';
  return $cfg;
}

function db(): mysqli {
  static $db;
  if ($db instanceof mysqli) return $db;

  $cfg = app_cfg();
  mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
  $db = new mysqli($cfg['db']['host'], $cfg['db']['user'], $cfg['db']['pass'], $cfg['db']['name']);
  $db->set_charset($cfg['db']['charset'] ?? 'utf8mb4');
  $db->query("SET time_zone = '+03:00'");
  return $db;
}
