<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_api_key();

$data  = read_json();
$phone = normalize_phone((string)($data['phone'] ?? ''));
$name  = trim((string)($data['name'] ?? ''));

if ($phone === '' || strlen($phone) < 9) json_out(['ok'=>false,'error'=>'Invalid phone'], 422);

$db = db();

$db->begin_transaction();
try {
  // Create or fetch customer
  $stmt = $db->prepare("SELECT id, name FROM loyalty_customers WHERE phone=? LIMIT 1");
  $stmt->bind_param("s", $phone);
  $stmt->execute();
  $row = $stmt->get_result()->fetch_assoc();
  $stmt->close();

  if ($row) {
    $customer_id = (int)$row['id'];
    if ($name !== '' && ($row['name'] ?? '') === '') {
      $u = $db->prepare("UPDATE loyalty_customers SET name=? WHERE id=?");
      $u->bind_param("si", $name, $customer_id);
      $u->execute();
      $u->close();
    }
  } else {
    $ins = $db->prepare("INSERT INTO loyalty_customers (phone, name) VALUES (?, ?)");
    $ins->bind_param("ss", $phone, $name);
    $ins->execute();
    $customer_id = (int)$ins->insert_id;
    $ins->close();

    $acc = $db->prepare("INSERT INTO loyalty_accounts (customer_id, tier, points_balance, lifetime_points) VALUES (?, 'Silver', 0, 0)");
    $acc->bind_param("i", $customer_id);
    $acc->execute();
    $acc->close();
  }

  $db->commit();

  json_out(['ok'=>true,'customer'=>['id'=>$customer_id,'phone'=>$phone,'name'=>$name]]);
} catch (Throwable $e) {
  $db->rollback();
  json_out(['ok'=>false,'error'=>'Register failed'], 500);
}
