<?php
require_once __DIR__ . '/../../includes/helpers.php';
require_api_key();

$phone = normalize_phone($_GET['phone'] ?? '');
if ($phone === '' || strlen($phone) < 9) json_out(['ok'=>false,'error'=>'Invalid phone'], 422);

$db = db();

$stmt = $db->prepare("
  SELECT c.id, c.phone, c.name, a.tier, a.points_balance
  FROM loyalty_customers c
  LEFT JOIN loyalty_accounts a ON a.customer_id = c.id
  WHERE c.phone = ?
  LIMIT 1
");
$stmt->bind_param("s", $phone);
$stmt->execute();
$r = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$r) json_out(['ok'=>true,'found'=>false,'phone'=>$phone]);

json_out([
  'ok'=>true,
  'found'=>true,
  'customer'=>[
    'id'=>(int)$r['id'],
    'phone'=>$r['phone'],
    'name'=>$r['name'],
    'tier'=>$r['tier'] ?? 'Silver',
    'points_balance'=>(int)($r['points_balance'] ?? 0),
  ]
]);
