<?php
require_once __DIR__ . '/../includes/helpers.php';
start_session();
$flash = flash_get();
$cfg = app_cfg();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // MVP auth: single admin password stored in app.php (you can replace with users table later)
  $pass = (string)($_POST['password'] ?? '');
  $admin_pass = (string)($cfg['security']['admin_password'] ?? 'admin123');
  if ($pass !== '' && hash_equals($admin_pass, $pass)) {
    $_SESSION['admin_user'] = 'admin';
    flash_set('Welcome.', 'success');
    header("Location: " . base_url() . "/admin/index.php");
    exit;
  }
  flash_set('Invalid password.', 'danger');
  header("Location: " . base_url() . "/admin/login.php");
  exit;
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Login • SmartPay Loyalty</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-light">
<div class="container py-5" style="max-width:520px;">
  <div class="card bg-black border border-secondary">
    <div class="card-body p-4">
      <h4 class="mb-1">Admin Login</h4>
      <div class="text-secondary mb-3">SmartPay Loyalty Bridge</div>
      <?php if($flash): ?>
        <div class="alert alert-<?=h($flash['type'])?>"><?=h($flash['msg'])?></div>
      <?php endif; ?>
      <form method="post">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control mb-3" autofocus required>
        <button class="btn btn-primary w-100">Login</button>
      </form>
      <div class="text-secondary mt-3 small">Change <code>security.admin_password</code> in <code>config/app.php</code>.</div>
    </div>
  </div>
</div>
</body>
</html>
