<?php
require_once __DIR__ . '/../includes/helpers.php';
require_admin();
$db = db();
$flash = flash_get();

$stats = [
  'customers' => (int)($db->query("SELECT COUNT(*) c FROM loyalty_customers")->fetch_assoc()['c'] ?? 0),
  'txns_today' => (int)($db->query("SELECT COUNT(*) c FROM loyalty_transactions WHERE DATE(created_at)=CURDATE()")->fetch_assoc()['c'] ?? 0),
  'points_today' => (int)($db->query("SELECT COALESCE(SUM(points_awarded),0) s FROM loyalty_transactions WHERE DATE(created_at)=CURDATE()")->fetch_assoc()['s'] ?? 0),
];

$rule = $db->query("SELECT * FROM loyalty_rules ORDER BY id DESC LIMIT 1")->fetch_assoc();

$q = trim((string)($_GET['q'] ?? ''));
$rows = [];
if ($q !== '') {
  $qq = normalize_phone($q);
  $stmt = $db->prepare("
    SELECT c.id, c.phone, c.name, a.tier, a.points_balance
    FROM loyalty_customers c
    LEFT JOIN loyalty_accounts a ON a.customer_id=c.id
    WHERE c.phone LIKE CONCAT('%', ?, '%') OR c.name LIKE CONCAT('%', ?, '%')
    ORDER BY c.id DESC LIMIT 50
  ");
  $stmt->bind_param("ss", $qq, $q);
  $stmt->execute();
  $rows = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
  $stmt->close();
}

$recent = $db->query("
  SELECT t.created_at, t.pos_txn_no, t.branch_code, t.cashier, t.sale_total, t.points_awarded, c.phone, c.name
  FROM loyalty_transactions t
  JOIN loyalty_customers c ON c.id=t.customer_id
  ORDER BY t.id DESC
  LIMIT 20
")->fetch_all(MYSQLI_ASSOC);

?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin • SmartPay Loyalty</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg bg-dark navbar-dark">
  <div class="container">
    <a class="navbar-brand" href="<?=h(base_url())?>/admin/index.php">SmartPay Loyalty</a>
    <div class="ms-auto d-flex gap-2">
      <a class="btn btn-outline-light btn-sm" href="<?=h(base_url())?>/admin/rules.php">Rules</a>
      <a class="btn btn-outline-light btn-sm" href="<?=h(base_url())?>/admin/logout.php">Logout</a>
    </div>
  </div>
</nav>

<div class="container py-4">
  <?php if($flash): ?>
    <div class="alert alert-<?=h($flash['type'])?>"><?=h($flash['msg'])?></div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-secondary">Customers</div>
          <div class="display-6"><?=h($stats['customers'])?></div>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-secondary">Awards Today</div>
          <div class="display-6"><?=h($stats['txns_today'])?></div>
          <div class="text-secondary small">Points: <?=h($stats['points_today'])?></div>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="text-secondary">Active Rule</div>
          <div><b><?=h($rule['note'] ?? '—')?></b></div>
          <div class="small text-secondary">points_per_kes: <?=h($rule['points_per_kes'] ?? '')?></div>
        </div>
      </div>
    </div>
  </div>

  <div class="card shadow-sm mt-4">
    <div class="card-body">
      <h5 class="mb-3">Find Customer</h5>
      <form class="row g-2">
        <div class="col-md-8">
          <input class="form-control" name="q" value="<?=h($q)?>" placeholder="Phone or name">
        </div>
        <div class="col-md-4">
          <button class="btn btn-primary w-100">Search</button>
        </div>
      </form>

      <?php if($q !== ''): ?>
        <div class="table-responsive mt-3">
          <table class="table table-sm align-middle">
            <thead><tr><th>Phone</th><th>Name</th><th>Tier</th><th>Points</th></tr></thead>
            <tbody>
            <?php foreach($rows as $r): ?>
              <tr>
                <td><?=h($r['phone'])?></td>
                <td><?=h($r['name'])?></td>
                <td><?=h($r['tier'] ?? 'Silver')?></td>
                <td><?=h($r['points_balance'] ?? 0)?></td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="card shadow-sm mt-4">
    <div class="card-body">
      <h5 class="mb-3">Recent Awards</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>When</th><th>Receipt</th><th>Branch</th><th>Cashier</th><th>Customer</th><th>Total</th><th>Points</th></tr></thead>
          <tbody>
          <?php foreach($recent as $t): ?>
            <tr>
              <td><?=h($t['created_at'])?></td>
              <td><?=h($t['pos_txn_no'])?></td>
              <td><?=h($t['branch_code'])?></td>
              <td><?=h($t['cashier'])?></td>
              <td><?=h($t['name'])?> <span class="text-secondary small">(<?=h($t['phone'])?>)</span></td>
              <td>KES <?=h(number_format((float)$t['sale_total'],2))?></td>
              <td><?=h($t['points_awarded'])?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</div>
</body>
</html>
