# SmartPay Loyalty Bridge MVP (RMS QSBridge + Hosted HTML)

This ZIP gives you a working MVP you can host on cPanel and call from Microsoft Dynamics RMS POS (via QSBridge trigger / custom button).

## What’s included
- Hosted POS popup: `public/loyalty_popup.html`
- API endpoints:
  - `GET api/loyalty/customer.php?phone=...`
  - `POST api/loyalty/register.php` (JSON)
  - `POST api/loyalty/award.php` (JSON)
- Admin UI:
  - `admin/login.php`
  - `admin/index.php`
  - `admin/rules.php`
- MySQL schema: `schema.sql`

## Install on cPanel (quick)
1. Upload and extract the ZIP into a folder/subdomain (e.g. `loyalty.smartpay360.co.ke`).
2. Create MySQL database + user (cPanel > MySQL).
3. Import `schema.sql` in phpMyAdmin.
4. Edit `config/app.php`:
   - db credentials
   - set `base_url` (optional)
   - set `security.api_key` to a strong key
   - set `security.admin_password` to a strong password
5. Open: `/public/` to verify.

## Using with RMS (concept)
- Configure RMS to launch the hosted `public/loyalty_popup.html` after tender.
- Your QSBridge script can pre-fill:
  - POS receipt number
  - branch code
  - cashier
  - sale total
- The popup returns a `receipt_note` string from SmartPay.
- Use QSBridge `SetTransactionNote` to save it to the receipt.

## Security
- API requires `X-API-KEY` header or `?api_key=` query.
- Change the API key before going live.
- Admin is password-only MVP (replace with users table later).

## Next upgrades (Phase 1.1)
- Offline queue + retry log table
- Tier engine (Silver/Gold/Platinum)
- Points redemption at POS
- Fraud flags dashboard
